jQuery(document).ready(function($) {
    // Özel karakterleri encode/decode etmek için yardımcı fonksiyonlar
    function encodeContent(str) {
        try {
            // Önce HTML entities'leri düzelt
            str = str.replace(/&amp;/g, '&')
                    .replace(/&lt;/g, '<')
                    .replace(/&gt;/g, '>')
                    .replace(/&quot;/g, '"')
                    .replace(/&#039;/g, "'")
                    .replace(/&#39;/g, "'");
            
            // Base64 encoding
            return btoa(unescape(encodeURIComponent(str)));
        } catch (e) {
            console.error('Encoding error:', e);
            return '';
        }
    }

    function decodeContent(str) {
        try {
            // Base64 decoding
            return decodeURIComponent(escape(atob(str)));
        } catch (e) {
            console.error('Decoding error:', e);
            return '';
        }
    }

    function truncateContent(content, maxLength = 500) {
        // HTML etiketlerini temizle
        var tempDiv = document.createElement("div");
        tempDiv.innerHTML = content;
        var textContent = tempDiv.textContent || tempDiv.innerText;
        
        if (textContent.length <= maxLength) return content;
        
        // İlk 500 karakteri al ve son kelimeyi tamamla
        var truncated = textContent.substr(0, maxLength);
        truncated = truncated.substr(0, Math.min(truncated.length, truncated.lastIndexOf(" ")));
        
        return truncated + "...";
    }

    // Feed template'i yükle
    var feedItemTemplate = $('#feed-item-template').html();
    var $newsContainer = $('.news-container');
    var currentRequest = null;

    // RSS kaynağına tıklandığında
    $('.feed-source-item').on('click', function(e) {
        e.preventDefault();
        var $this = $(this);
        var rssUrl = $this.data('url');

        // Aktif kaynağı işaretle
        $('.feed-source-item').removeClass('active');
        $this.addClass('active');

        // Önceki isteği iptal et
        if (currentRequest) {
            currentRequest.abort();
        }

        // Yükleniyor durumunu göster
        $newsContainer.html('<div class="loading-state">Haberler yükleniyor...</div>');

        // AJAX isteği
        currentRequest = $.ajax({
            url: bha_bot_ajax.ajax_url,
            type: 'POST',
            data: {
                action: 'fetch_rss_feeds',
                nonce: bha_bot_ajax.nonce,
                rss_url: rssUrl
            },
            success: function(response) {
                if (response.success && response.data) {
                    displayFeedItems(response.data);
                } else {
                    var errorMessage = response.data || 'Haberler yüklenirken bir hata oluştu.';
                    $newsContainer.html('<div class="error-state">' + errorMessage + '</div>');
                }
            },
            error: function(xhr, status, error) {
                console.error('AJAX Hatası:', status, error);
                var errorMessage = 'Haberler yüklenirken bir hata oluştu. Lütfen tekrar deneyin.';
                if (xhr.responseJSON && xhr.responseJSON.data) {
                    errorMessage = xhr.responseJSON.data;
                }
                $newsContainer.html('<div class="error-state">' + errorMessage + '</div>');
            }
        });
    });

    // Feed öğelerini görüntüle
    function displayFeedItems(items) {
        if (!items || items.length === 0) {
            $newsContainer.html('<div class="error-state">Bu kaynakta haber bulunamadı.</div>');
            return;
        }

        var html = '';
        items.forEach(function(item) {
            // Template değişkenlerini değiştir
            var itemHtml = feedItemTemplate
                .replace(/{title}/g, escapeHtml(item.title))
                .replace(/{image}/g, item.image_url || '')
                .replace(/{date}/g, formatDate(item.date))
                .replace(/{link}/g, item.link)
                .replace(/{excerpt}/g, escapeHtml(item.excerpt))
                .replace(/{encoded_content}/g, encodeContent(item.content))
                .replace(/{encoded_excerpt}/g, encodeContent(item.excerpt));

            html += itemHtml;
        });

        $newsContainer.html(html);

        // İçerik önizleme ve genişletme
        $('.news-card').each(function() {
            var $card = $(this);
            var $excerpt = $card.find('.news-excerpt p');
            var $preview = $card.find('.content-preview');
            var $fullContent = $card.find('.content-full');
            var $button = $card.find('.read-more-btn');
            
            // Özeti göster
            var excerpt = decodeContent($card.find('.save-draft-btn').data('encoded-excerpt'));
            $excerpt.html(excerpt);
            
            // İçeriği hazırla
            var content = decodeContent($card.find('.save-draft-btn').data('encoded-content'));
            var truncatedContent = truncateContent(content);
            
            $preview.html(truncatedContent);
            $fullContent.html(content);
            
            // Devamını gör butonu işlevselliği
            $button.on('click', function() {
                var $btn = $(this);
                var isExpanded = $fullContent.is(':visible');
                
                if (isExpanded) {
                    $fullContent.slideUp();
                    $preview.slideDown();
                    $btn.find('.dashicons').removeClass('dashicons-editor-contract').addClass('dashicons-editor-expand');
                } else {
                    $preview.slideUp();
                    $fullContent.slideDown();
                    $btn.find('.dashicons').removeClass('dashicons-editor-expand').addClass('dashicons-editor-contract');
                }
            });
        });

        // Taslak kaydetme
        $('.save-draft-btn').on('click', function() {
            var $btn = $(this);
            var $card = $btn.closest('.news-card');
            
            $btn.prop('disabled', true)
                .find('.dashicons')
                .removeClass('dashicons-welcome-write-blog')
                .addClass('dashicons-update-alt');

            // İçerik ve özeti decode et
            var content = decodeContent($btn.data('encoded-content'));
            var excerpt = decodeContent($btn.data('encoded-excerpt'));

            $.ajax({
                url: bha_bot_ajax.ajax_url,
                type: 'POST',
                data: {
                    action: 'save_draft_post',
                    security: bha_bot_ajax.nonce,
                    title: $btn.data('title'),
                    content: content,
                    excerpt: excerpt,
                    image_url: $btn.data('image'),
                    link: $btn.data('link'),
                    date: $btn.data('date')
                },
                success: function(response) {
                    if (response.success) {
                        $card.fadeOut(function() {
                            $(this).remove();
                            if ($('.news-card').length === 0) {
                                $newsContainer.html('<div class="initial-state"><div class="empty-icon"><span class="dashicons dashicons-welcome-widgets-menus"></span></div><p>Tüm haberler taslak olarak kaydedildi.</p></div>');
                            }
                        });
                    } else {
                        $btn.prop('disabled', false)
                            .find('.dashicons')
                            .removeClass('dashicons-update-alt')
                            .addClass('dashicons-welcome-write-blog');
                        
                        // Hata mesajı ve butonları içeren div
                        var errorHtml = '<div class="error-message-container">' +
                            '<p class="error-text">' + (response.data?.message || 'Bilinmeyen bir hata oluştu') + '</p>' +
                            '<div class="error-buttons">' +
                            '<button type="button" class="button button-primary tamam-btn">Tamam</button>' +
                            '<button type="button" class="button yine-de-kaydet-btn">Yine de Kaydet</button>' +
                            '</div>' +
                            '</div>';
                        
                        // Mevcut hata mesajını kaldır
                        $('.error-message-container').remove();
                        
                        // Yeni hata mesajını ekle
                        $card.append(errorHtml);
                        
                        // Tamam butonuna tıklandığında
                        $('.tamam-btn').on('click', function() {
                            $('.error-message-container').remove();
                        });
                        
                        // Yine de Kaydet butonuna tıklandığında
                        $('.yine-de-kaydet-btn').on('click', function() {
                            var $errorContainer = $(this).closest('.error-message-container');
                            $errorContainer.remove();
                            
                            // Force parametresi ile tekrar kaydetme işlemi
                            $.ajax({
                                url: bha_bot_ajax.ajax_url,
                                type: 'POST',
                                data: {
                                    action: 'save_draft_post',
                                    security: bha_bot_ajax.nonce,
                                    title: $btn.data('title'),
                                    content: decodeContent($btn.data('encoded-content')),
                                    excerpt: decodeContent($btn.data('encoded-excerpt')),
                                    image_url: $btn.data('image'),
                                    link: $btn.data('link'),
                                    date: $btn.data('date'),
                                    force: true // Zorla kaydetme parametresi
                                },
                                success: function(response) {
                                    if (response.success) {
                                        $card.fadeOut(function() {
                                            $(this).remove();
                                            if ($('.news-card').length === 0) {
                                                $newsContainer.html('<div class="initial-state"><div class="empty-icon"><span class="dashicons dashicons-welcome-widgets-menus"></span></div><p>Tüm haberler taslak olarak kaydedildi.</p></div>');
                                            }
                                        });
                                    } else {
                                        alert('Haber kaydedilirken bir hata oluştu: ' + (response.data?.message || 'Bilinmeyen bir hata'));
                                    }
                                },
                                error: function() {
                                    alert('Haber kaydedilirken bir hata oluştu.');
                                }
                            });
                        });
                    }
                },
                error: function(xhr, status, error) {
                    $btn.prop('disabled', false)
                        .find('.dashicons')
                        .removeClass('dashicons-update-alt')
                        .addClass('dashicons-welcome-write-blog');
                    var errorMessage = xhr.responseJSON?.data?.message || 'Bilinmeyen bir hata oluştu';
                    alert(errorMessage);
                }
            });
        });

        // Kuyruğa ekleme
        $('.add-to-queue-btn').on('click', function() {
            var $btn = $(this);
            var $card = $btn.closest('.news-card');
            
            $btn.prop('disabled', true)
                .find('.dashicons')
                .removeClass('dashicons-list-view')
                .addClass('dashicons-update-alt');

            // İçerik ve özeti decode et
            var content = decodeContent($btn.data('encoded-content'));
            var excerpt = decodeContent($btn.data('encoded-excerpt'));

            $.ajax({
                url: bha_bot_ajax.ajax_url,
                type: 'POST',
                data: {
                    action: 'add_to_queue',
                    security: bha_bot_ajax.nonce,
                    title: $btn.data('title'),
                    content: content,
                    excerpt: excerpt,
                    image_url: $btn.data('image'),
                    link: $btn.data('link'),
                    date: $btn.data('date')
                },
                success: function(response) {
                    if (response.success) {
                        $card.fadeOut(function() {
                            $(this).remove();
                            if ($('.news-card').length === 0) {
                                $newsContainer.html('<div class="initial-state"><div class="empty-icon"><span class="dashicons dashicons-welcome-widgets-menus"></span></div><p>Tüm haberler kuyruğa eklendi.</p></div>');
                            }
                        });
                    } else {
                        $btn.prop('disabled', false)
                            .find('.dashicons')
                            .removeClass('dashicons-update-alt')
                            .addClass('dashicons-list-view');
                        
                        alert('Haber kuyruğa eklenirken bir hata oluştu: ' + (response.data?.message || 'Bilinmeyen bir hata'));
                    }
                },
                error: function() {
                    $btn.prop('disabled', false)
                        .find('.dashicons')
                        .removeClass('dashicons-update-alt')
                        .addClass('dashicons-list-view');
                    
                    alert('Haber kuyruğa eklenirken bir hata oluştu.');
                }
            });
        });
    }

    // HTML karakterlerini escape et
    function escapeHtml(text) {
        if (!text) return '';
        var map = {
            '&': '&amp;',
            '<': '&lt;',
            '>': '&gt;',
            '"': '&quot;',
            "'": '&#039;'
        };
        return text.replace(/[&<>"']/g, function(m) { return map[m]; });
    }

    // Tarihi formatla
    function formatDate(dateStr) {
        if (!dateStr) return '';
        var date = new Date(dateStr);
        return date.toLocaleDateString('tr-TR', {
            year: 'numeric',
            month: 'long',
            day: 'numeric',
            hour: '2-digit',
            minute: '2-digit'
        });
    }

    // Akordiyon fonksiyonalitesi
    $('.category-title').on('click', function() {
        var $title = $(this);
        var $sources = $title.next('.feed-sources');
        
        // Tıklanan kategoriyi aç/kapat
        $title.toggleClass('collapsed');
        $sources.toggleClass('collapsed');
        
        // Diğer kategorileri kapat
        $('.category-title').not($title).addClass('collapsed');
        $('.feed-sources').not($sources).addClass('collapsed');
    });
    
    // İlk kategoriyi açık bırak, diğerlerini kapat
    $('.feed-category:first-child .category-title').removeClass('collapsed');
    $('.feed-category:first-child .feed-sources').removeClass('collapsed');
    $('.feed-category:not(:first-child) .category-title').addClass('collapsed');
    $('.feed-category:not(:first-child) .feed-sources').addClass('collapsed');
}); 