<?php

class BHA_Bot {
    protected $loader;
    protected $plugin_name;
    protected $version;

    public function __construct() {
        $this->plugin_name = 'bha-bot';
        $this->version = '1.0.0';
        
        $this->load_dependencies();
        $this->set_locale();
        $this->define_admin_hooks();
        $this->define_public_hooks();

        // Özel cron aralığını ekle
        add_filter('cron_schedules', array($this, 'add_cron_interval'));
    }

    private function load_dependencies() {
        require_once BHA_BOT_PLUGIN_DIR . 'includes/class-bha-bot-loader.php';
        $this->loader = new BHA_Bot_Loader();
    }

    private function set_locale() {
        // Dil ayarları için gerekli işlemler burada yapılabilir
        // Şimdilik boş bırakıyoruz
    }

    private function define_admin_hooks() {
        $plugin_admin = new BHA_Bot_Admin($this->get_plugin_name(), $this->get_version());
        
        // Admin menüsü ve sayfaları
        $this->loader->add_action('admin_menu', $plugin_admin, 'add_plugin_admin_menu');
        
        // Admin assets
        $this->loader->add_action('admin_enqueue_scripts', $plugin_admin, 'enqueue_styles');
        $this->loader->add_action('admin_enqueue_scripts', $plugin_admin, 'enqueue_scripts');
        
        // AJAX işleyicileri
        $this->loader->add_action('wp_ajax_fetch_rss_feeds', $plugin_admin, 'fetch_rss_feeds');
        $this->loader->add_action('wp_ajax_save_draft_post', $plugin_admin, 'save_draft_post');
        $this->loader->add_action('wp_ajax_add_to_queue', $plugin_admin, 'ajax_add_to_queue');

        // Cron işlemleri için hook'ları ekle
        $this->loader->add_action('bha_bot_process_image', $plugin_admin, 'process_image', 10, 3);
        $this->loader->add_action('bha_bot_process_taxonomies', $plugin_admin, 'process_taxonomies', 10, 3);
        $this->loader->add_action('bha_bot_auto_publish_cron', $plugin_admin, 'auto_publish_feeds');
        $this->loader->add_action('bha_bot_process_queue_cron', $plugin_admin, 'process_queue');
    }

    private function define_public_hooks() {
        // Ön yüz için gerekli hook'lar burada tanımlanabilir
        // Şimdilik boş bırakıyoruz
    }

    public function run() {
        $this->loader->run();
    }

    public function get_plugin_name() {
        return $this->plugin_name;
    }

    public function get_version() {
        return $this->version;
    }

    public function add_cron_interval($schedules) {
        $schedules['thirty_seconds'] = array(
            'interval' => 30,
            'display'  => 'Her 30 saniye'
        );

        $schedules['one_minute'] = array(
            'interval' => 60,
            'display'  => 'Her 1 dakika'
        );

        $schedules['two_minutes'] = array(
            'interval' => 120,
            'display'  => 'Her 2 dakika'
        );
        
        $schedules['five_minutes'] = array(
            'interval' => 300,
            'display'  => 'Her 5 dakika'
        );

        $schedules['ten_minutes'] = array(
            'interval' => 600,
            'display'  => 'Her 10 dakika'
        );

        $schedules['fifteen_minutes'] = array(
            'interval' => 900,
            'display'  => 'Her 15 dakika'
        );

        $schedules['thirty_minutes'] = array(
            'interval' => 1800,
            'display'  => 'Her 30 dakika'
        );

        $schedules['hourly'] = array(
            'interval' => 3600,
            'display'  => 'Her saat'
        );
        
        return $schedules;
    }
} 