<?php

class BHA_Bot_Deactivator {

    public static function deactivate() {
        error_log('BHA Bot deaktivasyon başladı');
        
        // Veritabanı bağlantısını kontrol et
        global $wpdb;
        if (!$wpdb->check_connection()) {
            error_log('HATA: WordPress veritabanı bağlantısı başarısız');
            return;
        }
        
        try {
            // Eklentiye ait tüm options değerlerini sil
            delete_option('bha_bot_rss_feeds');
            delete_option('bha_bot_version');
            delete_option('bha_bot_auto_publish_settings');
            delete_option('bha_bot_keyword_mappings');
            delete_option('bha_bot_start_date');
            delete_option('bha_bot_last_processed_index');
            delete_option('bha_bot_publish_queue');
            delete_option('bha_bot_processed_notices');
            
            // Zamanlanmış görevleri temizle
            wp_clear_scheduled_hook('bha_bot_auto_publish_cron');
            wp_clear_scheduled_hook('bha_bot_process_image');
            wp_clear_scheduled_hook('bha_bot_process_taxonomies');
            
            // Geçici verileri temizle
            $wpdb->query("DELETE FROM {$wpdb->options} WHERE option_name LIKE 'bha_bot_processed_%'");
            $wpdb->query("DELETE FROM {$wpdb->options} WHERE option_name LIKE '_transient_bha_bot_%'");
            $wpdb->query("DELETE FROM {$wpdb->options} WHERE option_name LIKE '_transient_timeout_bha_bot_%'");
            
            // Yönetici yetkilerini kaldır
            $role = get_role('administrator');
            if ($role) {
                $role->remove_cap('manage_bha_bot');
            }
            
            error_log('BHA Bot deaktivasyon başarıyla tamamlandı');
            
        } catch (Exception $e) {
            error_log('BHA Bot deaktivasyon hatası: ' . $e->getMessage());
        }
    }
} 